// Debug script to test Chrome extension functionality
console.log('=== Chrome Extension Debug ===');

// Test if extension is loaded
if (typeof chrome !== 'undefined' && chrome.runtime) {
    console.log('✓ Chrome runtime available');

    // Test extension connectivity
    try {
        const port = chrome.runtime.connect({ name: "mapsScraper" });
        console.log('✓ Extension connection successful');

        port.onDisconnect.addListener(() => {
            if (chrome.runtime.lastError) {
                console.error('✗ Extension disconnected:', chrome.runtime.lastError.message);
            } else {
                console.log('✓ Extension disconnected normally');
            }
        });

        port.onMessage.addListener((msg) => {
            console.log('✓ Extension message received:', msg);
        });

        // Send test message
        port.postMessage({
            tool: "mapsScraper",
            url: "https://www.google.com/maps/search/test",
            options: { maxItems: 5 },
            queue: "test"
        });

        console.log('✓ Test message sent');

    } catch (error) {
        console.error('✗ Extension connection failed:', error);
    }
} else {
    console.error('✗ Chrome runtime not available');
}

// Test window.postMessage functionality
console.log('Testing window.postMessage...');
window.postMessage({
    type: "EXT_SCRAPER_MESSAGE",
    tool: "mapsScraper",
    url: "https://www.google.com/maps/search/test",
    options: { maxItems: 5 },
    queue: "test"
}, "*");

console.log('=== Debug Complete ===');