// @ts-check
const path = require('path');
const { devices } = require('@playwright/test');

/** @type {import('@playwright/test').PlaywrightTestConfig} */
const config = {
  testDir: './tests',
  timeout: 60 * 1000,
  expect: {
    timeout: 10 * 1000,
  },
  webServer: {
    command: 'node server.js',
    cwd: path.join(__dirname),
    url: 'http://localhost:4170',
    reuseExistingServer: !process.env.CI,
    env: {
      ...process.env,
      MAIN_PORT: '4170',
    },
  },
  use: {
    baseURL: 'http://localhost:4170',
    screenshot: 'only-on-failure',
    trace: 'on-first-retry',
  },
  projects: [
    {
      name: 'Desktop Chrome',
      use: {
        ...devices['Desktop Chrome'],
        viewport: { width: 1280, height: 800 },
      },
    },
    {
      name: 'Tablet Firefox',
      use: {
        ...devices['Desktop Firefox'],
        viewport: { width: 1000, height: 720 },
      },
    },
    {
      name: 'Mobile Safari',
      use: {
        ...devices['iPhone 12'],
      },
    },
  ],
};

module.exports = config;
