const { test, expect } = require('@playwright/test');

const unique = () => Math.random().toString(36).slice(2, 7);

test.describe('LeadSniper marketing experience', () => {
  test('homepage renders hero content and client logos', async ({ page }) => {
    await page.goto('/');
    await expect(page.locator('h1')).toContainText('Turn every buying signal');
    await expect(page.locator('.logo-row img')).toHaveCount(5);
    const navProduct = page.getByRole('navigation').getByRole('link', { name: 'Product', exact: true });
    if (await navProduct.isVisible()) {
      await navProduct.click();
    } else {
      await page.getByRole('button', { name: 'Toggle navigation' }).click();
      await page.getByRole('link', { name: 'Product', exact: true }).first().click();
    }
    await expect(page).toHaveURL(/product\.html/);
  });

  test('tools hub navigation works', async ({ page }) => {
    await page.goto('/tools/google-map-scraper.html');
    await expect(page.locator('h1')).toContainText('Google Map Scraper');
    await page.getByRole('button', { name: 'Tools' }).click();
    await page.getByRole('link', { name: 'Email Verifier' }).first().click();
    await expect(page).toHaveURL(/email-verifier/);
    await expect(page.locator('h1')).toHaveText(/Email Verifier/);
    await page.getByRole('link', { name: 'Lead Routing Blueprint' }).first().click();
    await expect(page).toHaveURL(/blog\/lead-routing/);
  });

  test('forms submit and show success messaging', async ({ page }) => {
    await page.goto('/');
    const email = `qa-${unique()}@example.com`;
    const responsePromise = page.waitForResponse('**/api/signup');
    await page.getByLabel('Work email').fill(email);
    await page.getByLabel('Team size').selectOption('11-50');
    await page.getByLabel('Primary goal').fill('Automate routing checks');
    await page.getByRole('button', { name: 'Request access' }).click();
    const response = await responsePromise;
    expect(response.ok()).toBeTruthy();
    await expect(page.locator('[data-status]')).toContainText('Signup received');

    await page.goto('/contact.html#signup');
    await page.getByLabel('Full name').fill('QA Bot');
    await page.getByLabel('Work email').fill(`qa-${unique()}@example.com`);
    await page.getByLabel('Company').fill('LeadSniper QA');
    await page.getByLabel('Team size').selectOption('200+');
    await page.getByLabel('How can we help?').fill('Need enterprise onboarding.');
    const contactResponse = page.waitForResponse('**/api/contact');
    await page.getByRole('button', { name: 'Submit' }).click();
    const contactResult = await contactResponse;
    expect(contactResult.ok()).toBeTruthy();
    await expect(page.locator('[data-status]').last()).toContainText('LeadSniper specialist');
  });
});
