<?php
$publicDir = __DIR__;
$requestPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

if ($requestPath === '/' || $requestPath === '') {
    require $publicDir . '/google-map-scraper.html';
    return;
}

$fullPath = realpath($publicDir . $requestPath);
if ($fullPath && strncmp($fullPath, $publicDir, strlen($publicDir)) === 0 && is_file($fullPath)) {
    $ext = pathinfo($fullPath, PATHINFO_EXTENSION);
    if ($ext === 'php') {
        require $fullPath;
        return;
    }

    $mime = [
        'html' => 'text/html; charset=utf-8',
        'css' => 'text/css; charset=utf-8',
        'js' => 'application/javascript; charset=utf-8',
        'json' => 'application/json; charset=utf-8',
        'png' => 'image/png',
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'gif' => 'image/gif',
        'svg' => 'image/svg+xml',
        'ico' => 'image/x-icon',
        'webp' => 'image/webp',
        'woff' => 'font/woff',
        'woff2' => 'font/woff2',
    ][$ext] ?? null;

    if ($mime) {
        header('Content-Type: ' . $mime);
    }
    readfile($fullPath);
    return;
}

http_response_code(404);
echo '404 Not Found';
